/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.doors.DoorwayOrientation;
import technology.rocketjump.undermount.doors.DoorwaySize;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureType;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.DoorwayPlacementMessage;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.camera.PrimaryCameraWrapper;
import technology.rocketjump.undermount.rooms.Room;
import technology.rocketjump.undermount.rooms.RoomTile;
import technology.rocketjump.undermount.rooms.RoomType;
import technology.rocketjump.undermount.rooms.RoomTypeDictionary;
import technology.rocketjump.undermount.ui.GameInteractionMode;
import technology.rocketjump.undermount.ui.i18n.I18nTranslator;

@Singleton
public class GameInteractionStateContainer {
    private final PrimaryCameraWrapper primaryCameraWrapper;
    private boolean dragging;
    private Vector2 startPoint;
    private Vector2 currentPoint;
    private GameInteractionMode interactionMode;
    public Room virtualRoom;
    private RoomType currentRoomType;
    private GameMaterial selectedMaterialForFurniture;
    private Entity furnitureEntityToPlace;
    private boolean validFurniturePlacement;
    private DoorwayPlacementMessage virtualDoorPlacement;
    private FurnitureType selectedFurnitureType;
    private DebugWindow debugWindow;
    private final I18nTranslator i18nTranslator;
    private Entity selectedEntity;

    @Inject
    public GameInteractionStateContainer(PrimaryCameraWrapper primaryCameraWrapper, DebugWindow debugWindow, I18nTranslator i18nTranslator) {
        this.primaryCameraWrapper = primaryCameraWrapper;
        this.debugWindow = debugWindow;
        this.i18nTranslator = i18nTranslator;
        this.clearState();
    }

    public void clearState() {
        this.dragging = false;
        this.startPoint = new Vector2();
        this.currentPoint = new Vector2();
        this.interactionMode = GameInteractionMode.DEFAULT;
        this.virtualRoom = new Room(RoomTypeDictionary.VIRTUAL_PLACING_ROOM);
    }

    public void update(TiledMap map) {
        if (!this.virtualRoom.isEmpty()) {
            this.virtualRoom.clearTiles();
        }
        Vector3 worldPosition = this.primaryCameraWrapper.getCamera().unproject(new Vector3(Gdx.input.getX(), Gdx.input.getY(), 0.0f));
        Vector2 worldPosition2 = new Vector2(worldPosition.x, worldPosition.y);
        GridPoint2 tilePosition = VectorUtils.toGridPoint(worldPosition2);
        if (this.interactionMode.equals((Object)GameInteractionMode.PLACE_ROOM) && this.dragging) {
            int minX = (int)Math.floor(Math.min(this.startPoint.x, this.currentPoint.x));
            int maxX = (int)Math.floor(Math.max(this.startPoint.x, this.currentPoint.x));
            int minY = (int)Math.floor(Math.min(this.startPoint.y, this.currentPoint.y));
            int maxY = (int)Math.floor(Math.max(this.startPoint.y, this.currentPoint.y));
            LinkedList<RoomTile> newRoomTiles = new LinkedList<RoomTile>();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    MapTile tile = map.getTile(x, y);
                    if (tile == null || !this.interactionMode.designationCheck.shouldDesignationApply(tile)) continue;
                    GridPoint2 position = new GridPoint2(x, y);
                    RoomTile newRoomTile = new RoomTile();
                    newRoomTile.setRoom(this.virtualRoom);
                    newRoomTile.setTilePosition(position);
                    newRoomTile.setTile(tile);
                    tile.setRoomTile(newRoomTile);
                    this.virtualRoom.addTile(newRoomTile);
                    newRoomTiles.add(newRoomTile);
                }
            }
            this.virtualRoom.updateLayout(map);
        } else if (this.interactionMode.equals((Object)GameInteractionMode.PLACE_FURNITURE)) {
            this.debugWindow.printLine(this.i18nTranslator.getTranslatedString("GUI.ROTATE_FURNITURE.HINT"));
            if (this.furnitureEntityToPlace != null) {
                this.furnitureEntityToPlace.getLocationComponent().setWorldPosition(VectorUtils.toVector(tilePosition), false);
                FurnitureEntityAttributes attributes = (FurnitureEntityAttributes)this.furnitureEntityToPlace.getPhysicalEntityComponent().getAttributes();
                this.validFurniturePlacement = GameInteractionStateContainer.isFurniturePlacementValid(map, tilePosition, attributes);
            }
        } else if (this.interactionMode.equals((Object)GameInteractionMode.PLACE_DOOR)) {
            this.virtualDoorPlacement = this.isDoorPlacementValid(map, tilePosition);
        }
    }

    private DoorwayPlacementMessage isDoorPlacementValid(TiledMap map, GridPoint2 tilePosition) {
        MapTile targetTile = map.getTile(tilePosition);
        if (targetTile == null || !targetTile.isEmpty()) {
            return null;
        }
        MapTile north = map.getTile(tilePosition.cpy().add(0, 1));
        MapTile south = map.getTile(tilePosition.cpy().add(0, -1));
        MapTile west = map.getTile(tilePosition.cpy().add(-1, 0));
        MapTile east = map.getTile(tilePosition.cpy().add(1, 0));
        if (north == null || south == null || west == null || east == null) {
            return null;
        }
        if (north.hasWall() && south.hasWall() && east.isEmptyExceptEntities() && west.isEmptyExceptEntities()) {
            return new DoorwayPlacementMessage(DoorwaySize.SINGLE, DoorwayOrientation.NORTH_SOUTH, this.selectedMaterialForFurniture, tilePosition);
        }
        if (west.hasWall() && east.hasWall() && north.isEmptyExceptEntities() && south.isEmptyExceptEntities()) {
            return new DoorwayPlacementMessage(DoorwaySize.SINGLE, DoorwayOrientation.EAST_WEST, this.selectedMaterialForFurniture, tilePosition);
        }
        return new DoorwayPlacementMessage(null, null, this.selectedMaterialForFurniture, tilePosition);
    }

    public static boolean isFurniturePlacementValid(TiledMap map, GridPoint2 tilePosition, FurnitureEntityAttributes attributes) {
        LinkedList<GridPoint2> positionsToCheck = new LinkedList<GridPoint2>();
        positionsToCheck.add(tilePosition);
        for (GridPoint2 extraTileOffset : attributes.getCurrentLayout().getExtraTiles()) {
            positionsToCheck.add(tilePosition.cpy().add(extraTileOffset));
        }
        for (GridPoint2 positionToCheck : positionsToCheck) {
            RoomTile roomTile;
            MapTile tileToCheck = map.getTile(positionToCheck);
            if (tileToCheck == null || !tileToCheck.isEmpty()) {
                return false;
            }
            if (attributes.getFurnitureType().isPlaceAnywhere() || (roomTile = tileToCheck.getRoomTile()) != null && attributes.getFurnitureType().getValidRoomTypes().contains(roomTile.getRoom().getRoomType())) continue;
            return false;
        }
        if (attributes.getCurrentLayout().getWorkspaces().size() > 0) {
            boolean oneWorkspaceAccessible = false;
            for (FurnitureLayout.Workspace workspace : attributes.getCurrentLayout().getWorkspaces()) {
                GridPoint2 workspaceAccessedFrom = tilePosition.cpy().add(workspace.getAccessedFrom());
                if (!map.getTile(workspaceAccessedFrom).isEmpty()) continue;
                oneWorkspaceAccessible = true;
                break;
            }
            if (!oneWorkspaceAccessible) {
                return false;
            }
        }
        return true;
    }

    public Vector2 getMinPoint() {
        Vector2 minPoint = new Vector2();
        minPoint.x = Math.min(this.startPoint.x, this.currentPoint.x);
        minPoint.y = Math.min(this.startPoint.y, this.currentPoint.y);
        return minPoint;
    }

    public Vector2 getMaxPoint() {
        Vector2 maxPoint = new Vector2();
        maxPoint.x = Math.max(this.startPoint.x, this.currentPoint.x);
        maxPoint.y = Math.max(this.startPoint.y, this.currentPoint.y);
        return maxPoint;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public Vector2 getStartPoint() {
        return this.startPoint;
    }

    public void setStartPoint(Vector2 startPoint) {
        this.startPoint = startPoint;
    }

    public Vector2 getCurrentPoint() {
        return this.currentPoint;
    }

    public void setCurrentPoint(Vector2 currentPoint) {
        this.currentPoint = currentPoint;
    }

    public GameInteractionMode getInteractionMode() {
        return this.interactionMode;
    }

    public void setInteractionMode(GameInteractionMode interactionMode) {
        this.interactionMode = interactionMode;
    }

    public void setSelectedMaterialForFurniture(GameMaterial selectedMaterialForFurniture) {
        this.selectedMaterialForFurniture = selectedMaterialForFurniture;
    }

    public GameMaterial getSelectedMaterialForFurniture() {
        return this.selectedMaterialForFurniture;
    }

    public Entity getFurnitureEntityToPlace() {
        return this.furnitureEntityToPlace;
    }

    public void setFurnitureEntityToPlace(Entity furnitureEntityToPlace) {
        this.furnitureEntityToPlace = furnitureEntityToPlace;
    }

    public boolean isValidFurniturePlacement() {
        return this.validFurniturePlacement;
    }

    public boolean isValidDoorPlacement() {
        return this.virtualDoorPlacement != null && this.virtualDoorPlacement.getDoorwaySize() != null;
    }

    public DoorwayPlacementMessage getVirtualDoorPlacement() {
        return this.virtualDoorPlacement;
    }

    public RoomType getCurrentRoomType() {
        return this.currentRoomType;
    }

    public void setCurrentRoomType(RoomType currentRoomType) {
        this.currentRoomType = currentRoomType;
    }

    public void setSelectedFurnitureType(FurnitureType selectedFurnitureType) {
        this.selectedFurnitureType = selectedFurnitureType;
    }

    public FurnitureType getSelectedFurnitureType() {
        return this.selectedFurnitureType;
    }

    public void setSelectedEntity(Entity selectedEntity) {
        this.selectedEntity = selectedEntity;
    }

    public Entity getSelectedEntity() {
        return this.selectedEntity;
    }
}

